// koorddlg.h : header file
//
#include "DlgTool.h"

/////////////////////////////////////////////////////////////////////////////
// CWayDlg dialog     
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

class CNameList;
class CWayDoc;
class CWayDlg : public CDlgTool
{
// Construction
public:   
	
	CWayDlg(CWnd* pParent = NULL, CWayDoc* ptDoc=NULL);	// standard constructor
	~CWayDlg();  

	BOOL WriteRouteIntoDoc();

private: 
	void DeleteArrayOf (CObArray* ptArray);
	void ReadRouteFromDoc();

// Dialog Data
	//{{AFX_DATA(CWayDlg)
	enum { IDD = IDD_WAYBOX };
	long	m_lPlannedAlt;
	CString	m_szName;
	int		m_nAltDim;
	int		m_nListIndex;
	CString	m_szCC;
	int		m_nAlternate;
	//}}AFX_DATA

BOOL		m_bInsert;
BOOL		m_bKoordOK;
BOOL		m_bBearingOK;
BOOL		m_bChangeMode;
BOOL		m_bTypeMode;
BOOL		m_bWptDeleted;		// to avoid using FindBestName 
BOOL		m_bInitialAlternatePUIndex;

CWayDoc* 	m_ptDoc;
CWayPoint	m_ActWpt;
CObArray	m_ActList;		// actual way point array
short		m_nOldIndex;
BOOL		m_bChanged;           
CQuickFind*	m_ptQuickFind;
CNameList*	m_ptNameList;
short		m_nLastTypedLen; 
CLaLoList*  m_ptLaLoList;	// list of possible map entries

// Implementation
private:
	void CheckFirstPlannedAlt (CWayPoint& Wpt);

protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support  

	BOOL FacilityInRange (CLocation& ActLoc);
	void PrepareButtons();
	BOOL SearchInDataBase (CString szName, CWayPoint* ptWayPt);
	BOOL GetLocus (CWayPoint* ptWayPt);
	void SetWpt (CWayPoint* ptWayPt);
	BOOL GetWpt (CWayPoint* ptWayPt);
	void FillWayList (CObArray* ptWays); 
	void FillAlternatePU ();
	short SetAlternatePU();

	short OnNewList (CObArray* ptWays);
	BOOL SameLocus();
	void InsertAfter(CWayPoint WayPt);	
	BOOL DoExchangeName (CLocation* ptLoc, CString szActName);
	void SelPartName (short nTypedLen, CString szName);
	void TryToReadLatLon (CWayPoint* ptWayPt);

	// Generated message map functions
	//{{AFX_MSG(CWayDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSelchangeList();
	afx_msg void OnInsert();
	afx_msg void OnDelete();
	afx_msg void OnChange();
	afx_msg void OnSelChangeAltDim();
	afx_msg void OnSelChangeAlternates();
	afx_msg void OnAuto();
	afx_msg void OnRel();
	afx_msg void OnManu();
	afx_msg void OnBearing();
	afx_msg void OnRegionDlg();
	afx_msg void OnChangeLocName();
	afx_msg void OnExchangeWayName();
	afx_msg void OnDblclkWayList();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
