// wayview.cpp : implementation of the CWayView class
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "stdafx.h"
#include "pf.h"

#include "InitDoc.h"  
#include "MetDoc.h"
#include "LocDoc.h"
#include "PlaneDoc.h"

#include "WayDoc.h"
#include "wayview.h"                                           

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

extern CInitDoc* 		ptInit;
extern CFontDoc* 		ptFontTool;
extern CDimDoc* 		ptDim;      

extern CLoadDoc*		ptLoad; 
extern CCalcDoc*		ptCalc;
extern CAppendixDoc*	ptAppend;  
extern CMetDoc*			ptMet;
extern CPlaneDoc*		ptPlaneDoc;
extern BOOL bMMText;

/////////////////////////////////////////////////////////////////////////////
// CWayView

IMPLEMENT_DYNCREATE(CWayView, CTextViewTool)

BEGIN_MESSAGE_MAP(CWayView, CTextViewTool)
	//{{AFX_MSG_MAP(CWayView)
	ON_COMMAND(ID_EDIT_COPY, OnEditCopy)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTextViewTool::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTextViewTool::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWayView construction/destruction

CWayView::CWayView()
{
	// TODO: add construction code here
ptFontTool->GetParams (m_FontName, &m_wPointSize);

m_CharX = m_LineY = 0;
m_BCharX = m_BLineY = 0;

CreateBoldFont(&m_BoldFont);
CreateNewFont(&m_PlainFont);
}

CWayView::~CWayView()
{
   	m_PlainFont.DeleteObject ();
 	m_BoldFont.DeleteObject ();
}

/************************************************************************
 *  WayView.cpp				U p d a t e F o n t s 						*
 ************************************************************************/
void CWayView::UpdateFonts (CDC* pDC)
{
ptFontTool->GetParams (m_FontName, &m_wPointSize);
m_lfHeight = this->Y_PointToLP (pDC, m_wPointSize);  

m_PlainFont.DeleteObject ();
CreateNewFont(&m_PlainFont);
this->GetCharSize (pDC, &m_PlainFont, &m_CharX, &m_LineY); 

m_BoldFont.DeleteObject ();
CreateBoldFont(&m_BoldFont);
this->GetCharSize (pDC, &m_BoldFont, &m_BCharX, &m_BLineY); 

		//	used to get fixed left margin and defined "max" char width
GetLeftMarginAndCharX_LP (m_wPointSize, &m_CharX);	// defines m_LeftMargin, m_CharX
}

/************************************************************************
 *  WayView.cpp			O n I n i t i a l U p d a t e					*
 *  calls OnUpdate
 ************************************************************************/
void CWayView::OnInitialUpdate()
{
	CTextViewTool::OnInitialUpdate();
	// TODO: calculate the total size of this view

CDC* pDC = GetDC();    
//pDC->SetMapMode(MM_LOMETRIC);

//this->UpdateFonts (pDC);

ReleaseDC(pDC);     
}

/************************************************************************
 *  WayView.cpp   				  S e t X T a b s 						*
 ************************************************************************/
void CWayView::SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX)
{
int X_TAB, LogPixXToUse, LogPixYToUse;
GetLogPixToUse(pDC, (int*)&LogPixXToUse, (int*)&LogPixYToUse);   

//X_TAB = (m_bForPrinter? 4 : 2)*CharX;
X_TAB = m_LeftMargin;
m_dY = LogPixYToUse;
m_Xleft  = X_TAB;

short nMaxNameLen;
nMaxNameLen = ptWayDoc->GetMaxLocNameLen (pDC); 

if (nMaxNameLen == 0)                        
	nMaxNameLen = GetRightPos (pDC, 0, IDS_PLACE);

m_Xloc = m_Xleft + CharX; 
m_Xlat = GetRightPos (pDC, m_Xloc + nMaxNameLen + CharX, IDS_LAT); 
m_Xlon = GetRightPos (pDC, m_Xlat+2*CharX, IDS_LON);
m_Xvar = GetRightPos (pDC, m_Xlon+2*CharX, IDS_VAR);
m_Xfreq = GetRightPos (pDC, m_Xvar+3*CharX, IDS_FREQ);
m_Xalt = GetRightPos (pDC, m_Xfreq+CharX, IDS_ALT);


m_Xright = m_Xalt + CharX;
m_dX = m_Xright - m_Xleft;
}

/************************************************************************
 *  WayView.cpp				P r e p a r e X T a b s						* 
 ************************************************************************/
void CWayView::PrepareXTabs (CDC* pDC)
{
CWayDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	pDC->SetMapMode(MM_LOMETRIC);
	this->UpdateFonts (pDC);					// defines m_CharX
	CFont* ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);		
    this->SetXTabs (pDC, pDoc, m_CharX);
	pDC->SelectObject (ptOldFont);
	}
}

/************************************************************************
 *  WayView.cpp					O n U p d a t e 						* 
 *  Called on FileNew, FileOpen, Doc.UpdateAllViews 					*
 ************************************************************************/
void CWayView::OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint)
{
CWayDoc* pDoc = GetDocument();

if (pDoc != NULL)
	{	        
	CDC* pDC = GetDC();    
	pDC->SetMapMode(MM_LOMETRIC);

	this->PrepareXTabs (pDC);
	m_bDraw = FALSE;
	this->OnDraw(pDC);						// sets m_sizeTotal
	m_bDraw = TRUE;
	this->SetScrollSize (m_sizeTotal);

	ReleaseDC(pDC);     
	
	CTextViewTool::OnUpdate (pSender, lHint, pHint);
	}	 
}


/************************************************************************
 *  WayView.cpp   			 O n P r e p a r e D C						*
 ************************************************************************/
void CWayView::OnPrepareDC(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class

CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	    
	m_bForPrinter = pDC->IsPrinting();	  // important to get correct update after 
	if (m_bForPrinter)					  // printing dlg disappears!!
		{
		int	X, Y;
		DWORD	dwIndex = 0; 
		BOOL bMore = TRUE;

		m_nPages = 0;

		this->PrepareXTabs (pDC);
   						
		m_dwLinesPerPage = this->GetMaxLines (pDC, m_LineY);   // used in DrawKoord	while m_bForPrinter
			
		m_bDraw = FALSE;
		do	{    
			X = m_Xleft;
			Y = 3*m_LineY;

 			this->DrawPageHeader (pDC, pDoc, m_LineY, &Y, m_dX, FALSE); 
			bMore = DrawWay (pDC, pDoc, &dwIndex, &Y, FALSE); // sets m_sizeTotal

 		//	this->DrawPageFooter (pDC, 0, m_LineY, &X, &Y, m_dX, FALSE); 
		//  there is place for footer after last line !! see GetLogPixToUse
 			m_nPages++;
			} while (bMore);
		m_bDraw = TRUE;


		if (pInfo != NULL)
			{
			pInfo->SetMaxPage (m_nPages);
			pInfo->m_nNumPreviewPages = m_nPages;
			pInfo->m_bContinuePrinting = (m_bMore || pInfo->m_bPreview);
			}    
		}  // if m_bForPrinter
	else{
		this->PrepareXTabs (pDC);
		}
	}
		
if (!m_bForPrinter)
	CTextViewTool::OnPrepareDC(pDC, pInfo);	 // sets bContinuePrinting = TRUE if SetMaxPage is set
}


/////////////////////////////////////////////////////////////////////////////
// CWayView drawing

/************************************************************************
 *  WayView.cpp    		 	 D r a w W a y	 							*
 ************************************************************************/
BOOL CWayView::DrawWay (CDC* pDC, CWayDoc* ptWayDoc, 
						DWORD* ptIndex,
					    int* ptY, BOOL bDraw)
{
BOOL	bEndOfPage = FALSE;

short	Y_SEP;

ActivateDrawing (bDraw);
pDC->SetBkMode(TRANSPARENT);

CFont* ptOldFont;
ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);
RsrcAlignLeftEx (pDC, m_Xleft, *ptY, IDS_FILE, (LPCTSTR)ptWayDoc->GetTitle());
pDC->SelectObject (ptOldFont);

(*ptY) += m_LineY;  
(*ptY) += m_LineY;  


							// title of table
Y_SEP = DrawHorzLine (pDC, *ptY+m_LineY/2);
(*ptY) += m_LineY;  


ptOldFont = (CFont*)pDC->SelectObject (&m_BoldFont);
RsrcAlignLeft  (pDC, m_Xloc,	*ptY, IDS_PLACE);
RsrcAlignRight (pDC, m_Xlat,	*ptY, IDS_LAT);
RsrcAlignRight (pDC, m_Xlon,	*ptY, IDS_LON);
RsrcAlignRight (pDC, m_Xvar,	*ptY, IDS_VAR);
RsrcAlignRight (pDC, m_Xfreq,	*ptY, IDS_FREQ);
RsrcAlignRight (pDC, m_Xalt,	*ptY, IDS_ALT);
pDC->SelectObject (ptOldFont);

(*ptY) += m_LineY;  

ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

									// dimensions
CString szDim;
ptDim->GetDimCstring (&szDim, ptDim->Altitude());
TextAlignRight (pDC, m_Xalt, *ptY, szDim);
(*ptY) += m_LineY;  

DrawHorzLine (pDC, *ptY+m_LineY/2);
(*ptY) += m_LineY;  

									// data of waypoints
short i;
short nCnt = ptWayDoc->GetWayPointCnt();
for (i=(short)*ptIndex; i<nCnt && !bEndOfPage; i++)
	{
	CWayPoint Wpt;
	if (ptWayDoc->GetWayPointPtr (i, &Wpt))
		{
		CLocation Loc;
		Loc = Wpt.GetLoc();
		TextAlignLeft (pDC, m_Xloc, *ptY, Loc.GetNameForRte());


		if (bDraw)
			{
			DrawAngle (pDC, m_Xlat, *ptY, &Loc, TRUE);
			DrawAngle (pDC, m_Xlon, *ptY, &Loc, FALSE);
			ptWayDoc->DrawVariation (pDC, m_Xvar, *ptY, m_CharX, Loc.GetVariation());

			float fFreq;
			if (Loc.GetFrequency(&fFreq))
				{
				RsrcAlignRightEx (pDC, m_Xfreq, *ptY, IDF_7K3F, fFreq);
				}

			long lAlt = Wpt.GetPlannedAlt ();
			if (lAlt != NO_ALT)
				{
				short nAltDim = Wpt.GetAltDim ();
				double fConvert = ptDim->ConvertToPref (ALTITUDE, lAlt, nAltDim);
				RsrcAlignRightEx (pDC, m_Xalt, *ptY, IDF_D, (short)fConvert);
				}
			}

		(*ptY) += m_LineY;  
		}

 	if (m_bForPrinter)
		{
		int NextY = m_LineY;
		bEndOfPage = (bMMText)? 
				((DWORD)(*ptY + 1*m_LineY + NextY) > (m_dwLinesPerPage * m_LineY)) :
				((DWORD)(*ptY + 1*m_LineY + NextY) < (m_dwLinesPerPage * m_LineY))	;

		if (bEndOfPage)
			{
			if (i<nCnt-1)	*ptIndex = i+1;
				else		bEndOfPage = FALSE;
			}
		}
	}

DrawHorzLine (pDC, *ptY+m_LineY/2);
DrawVertLines (pDC, m_Xleft, m_Xright, Y_SEP, *ptY+m_LineY/2); 
(*ptY) += m_LineY;

if (!m_bDraw && !m_bForPrinter)
	{
	this->SetTotalHeight (*ptY);
	this->SetTotalWidth (m_Xright + m_Xleft);
	}

pDC->SelectObject (ptOldFont);

return bEndOfPage;
}

/************************************************************************
 *  WayView.c				D r a w A n g l e							*
 ************************************************************************/
void CWayView::DrawAngle (CDC* pDC, int X, int Y, CLocation* ptLocation, BOOL bLat)
{   
double	fAngle;
short	Grad, Min, Sec, Dir;
int	nLen;

if (bLat) 	fAngle = ptLocation->GetLat();
	else	fAngle = ptLocation->GetLon();
 		           
ptLocation->AngleToDMS (fAngle, bLat, &Grad, &Min, &Sec, &Dir);

pDC->SetTextAlign (TA_RIGHT | TA_TOP);

CString szFormat;      
char	szBuffer[64];


LATLONFORM LatLonForm;
LatLonForm = ptDim->GetLatLonFormat();
if (LatLonForm == LLF_GGGMMSS)
	{
	szFormat.LoadString (IDS_F_DMS);
	nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Grad, Min, Sec);
	pDC->TextOut (X-m_CharX, Y, (LPSTR)szBuffer, nLen);
	}
else{		// if (LatLonForm == LLF_GGGMMm
	double dMin = Min + (float)Sec/60;
	szFormat.LoadString (IDS_F_DMM);
	nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Grad, dMin);
	pDC->TextOut (X-m_CharX, Y, (LPSTR)szBuffer, nLen);
	}

szFormat.LoadString (IDS_F_CHAR);
nLen = sprintf (szBuffer, (LPCTSTR)szFormat, Dir);
pDC->TextOut (X, Y, (LPSTR)szBuffer, nLen);
}      

/************************************************************************
 *  WayView.cpp			D r a w P a g e H e a d e r 					*
 ************************************************************************/
void CWayView::DrawPageHeader (CDC* pDC, CWayDoc* ptWayDoc, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
int	Y1, Frame;
CWayPoint FirstWayPt, LastWayPt;
CFont* ptOldFont;

ActivateDrawing (bDraw);

Y1 = *ptY + 3*LineY;			/* Draw double line frame	*/ 
if (bDraw) Rectangle(pDC, m_Xleft, *ptY, m_Xleft + dX, Y1);

Frame = (LineY/4);
if (bDraw)
	{ 
	if (bMMText)Rectangle(pDC, m_Xleft+Frame, *ptY+Frame, m_Xleft + dX-Frame, Y1-Frame);
		else	Rectangle(pDC, m_Xleft-Frame, *ptY+Frame, m_Xleft + dX+Frame, Y1-Frame);
	}


ptOldFont = (CFont*)pDC->SelectObject (&m_PlainFont);

Y1 = *ptY+LineY/2;
RsrcAlignCenter (pDC, (m_Xleft + dX + m_Xleft)/2, Y1, IDS_TITLE1);

Y1 += LineY;

short nCnt= ptWayDoc->GetWayPointCnt ();
if (ptWayDoc->GetWayPointPtr (0, &FirstWayPt) &&
	ptWayDoc->GetWayPointPtr(nCnt-1, &LastWayPt))
	{
	CString szName1, szName2;
	CLocation Loc;
	FirstWayPt.GetLoc (&Loc);
	szName1 = Loc.GetName();

	LastWayPt.GetLoc (&Loc);
	szName2 = Loc.GetName();

	CString szUserName = ptInit->GetCustName();

	RsrcAlignCenterEx (pDC, (m_Xleft + dX + m_Xleft)/2, Y1,
		IDF_TITLE2, (LPCTSTR)szName1, (LPCTSTR)szName2, (LPCTSTR)szUserName);
	}

pDC->SelectObject (ptOldFont);

*ptY = Y1 + 3*LineY;
}

/************************************************************************
 *  WayView.cpp    	 	 D r a w P a g e F o o t e r 					*
 ************************************************************************/
void CWayView::DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw)
{
CString szFormat;

//(*ptY) += LineY;
//if (bDraw) pDC->MoveTo (m_Xleft, *ptY);
//if (bDraw) pDC->LineTo (m_Xleft + dX, *ptY);

(*ptY) += LineY/2;
szFormat = this->Format (IDF_PAGENUM, nPage);
this->TextAlignCenter (pDC, dX/2, *ptY, szFormat);
}       

/************************************************************************
 *  WayView.cpp   			  P r i n t P a g e							*
 ************************************************************************/
void CWayView::PrintPage (CDC* pDC, int nPageToPrint)
{
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);

int	Y;
int	nPage = 1;


DWORD dwIndex = 0;

if (pDoc != NULL)
	{
	BOOL bDraw;

	do	{
		Y = 3*m_LineY;

		bDraw = (nPage == nPageToPrint);
		this->DrawPageHeader (pDC, pDoc, m_LineY, &Y, m_dX, bDraw); 
		m_bMore = DrawWay (pDC, pDoc, &dwIndex, &Y, bDraw);

		if (m_nPages > 1)
			{
			Y = (bMMText)? m_dY: -m_dY + m_LineY;
			this->DrawPageFooter (pDC, nPage, m_LineY, &Y, m_dX, bDraw); 
			}
		nPage++;
		} while (!bDraw);
	}    
}                                  


/************************************************************************
 *  WayView.cpp    	 			 O n D r a w							*
 ************************************************************************/
void CWayView::OnDraw(CDC* pDC)
{
	CWayDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here            

int	X_TAB = 4*m_CharX;
int	Y = m_LineY;

if (pDoc != NULL)
	{
	BOOL	bMore = FALSE;
	DWORD 	dwIndex = 0;

	bMore = DrawWay (pDC, pDoc, &dwIndex, &Y, m_bDraw);
	}	
}	 



/////////////////////////////////////////////////////////////////////////////
// CWayView printing

/************************************************************************
 *  WayView.cpp   		  O n P r e p a r e P r i n t i n g				*
 ************************************************************************/
BOOL CWayView::OnPreparePrinting(CPrintInfo* pInfo)
{			 // called before the display of the print dialog
	// default preparation
m_bMore = TRUE;	               

return DoPreparePrinting(pInfo);
}

/************************************************************************
 *  WayView.cpp   		 	O n B e g i n P r i n t i n g				*
 ************************************************************************/
void CWayView::OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo)
{			   // called after the print dialog exists
	// TODO: add extra initialization before printing
CWayDoc* pDoc = GetDocument();
ASSERT_VALID(pDoc);  

if (pDoc != NULL)
	{	        
//	pDC->SetMapMode(MM_LOMETRIC);

//	this->UpdateFonts (pDC);					// defines m_CharX

//  this->SetXTabs (pDC, pDoc, m_CharX);
	}
							// 2. possibility to set the document length 
}


/************************************************************************
 *  WayView.cpp   		 		 O n P r i n t							*
 ************************************************************************/
void CWayView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	// TODO: Add your specialized code here and/or call the base class
this->PrintPage (pDC, pInfo->m_nCurPage);
}

/************************************************************************
 *  WayView.cpp   		 		 O n E n d P r i n t i n g				*
 ************************************************************************/
void CWayView::OnEndPrinting(CDC* pDC, CPrintInfo* pInfo) 
{
}

/////////////////////////////////////////////////////////////////////////////
// CWayView diagnostics

#ifdef _DEBUG
void CWayView::AssertValid() const
{
	CTextViewTool::AssertValid();
}

void CWayView::Dump(CDumpContext& dc) const
{
	CTextViewTool::Dump(dc);
}

CWayDoc* CWayView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CWayDoc)));
	return (CWayDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWayView message handlers




void CWayView::OnEditCopy() 
{
	// TODO: Add your command handler code here
this->CopyToClipboard();		
}
