// wayview.h : interface of the CWayView class
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de
/////////////////////////////////////////////////////////////////////////////

#include "..\CPPTOOLS\TxVwTool.h"

class CWayView : public CTextViewTool
{
public:
	CFont	m_PlainFont; 
	CFont	m_BoldFont; 
	int		m_CharX, m_LineY;
	int		m_BCharX, m_BLineY;

	int m_Xloc, m_Xlat, m_Xlon, m_Xvar, m_Xfreq, m_Xalt;
 
public: // create from serialization only
	CWayView();
	DECLARE_DYNCREATE(CWayView)

// Attributes
public:
	CWayDoc* GetDocument();

// Operations
public:

// Implementation
public:
	virtual ~CWayView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:
	void UpdateFonts (CDC* pDC);
	void SetXTabs (CDC* pDC, CWayDoc* ptWayDoc, int CharX);
	void PrepareXTabs (CDC* pDC);

	BOOL DrawWay (CDC* pDC, CWayDoc* ptWayDoc, DWORD* ptIndex,
					int* ptY, BOOL bDraw = TRUE);
	void DrawAngle (CDC* pDC, int X, int Y, CLocation* ptLocation, BOOL bLat);

 	void DrawPageHeader (CDC* pDC, CWayDoc* ptWayDoc, int LineY, 
								int* ptY, int dX, BOOL bDraw);
	void DrawPageFooter (CDC* pDC, int nPage, int LineY, 
								int* ptY, int dX, BOOL bDraw);
	void PrintPage (CDC* pDC, int nPageToPrint);


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CMusterView)
public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnPrepareDC(CDC* pDC, CPrintInfo* pInfo = NULL);
protected:
	virtual void OnUpdate (CView* pSender, LPARAM lHint, CObject* pHint);
	virtual void OnInitialUpdate(); // called first time after construct
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo); 
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL



// Generated message map functions
protected:
	//{{AFX_MSG(CWayView)
	afx_msg void OnEditCopy();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in wayview.cpp
inline CWayDoc* CWayView::GetDocument()
   { return (CWayDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
