#if !defined(AFX_COLTBDLG_H__3E479CE0_F1BA_11D6_9274_004005651F5A__INCLUDED_)
#define AFX_COLTBDLG_H__3E479CE0_F1BA_11D6_9274_004005651F5A__INCLUDED_


#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// ColTbDlg.h : Header-Datei
//
// (c) Copyright Softwareentwicklung Heinz Ldert 2008
// http://www.preflight.de

#include "DlgTool.h"
#include "ElevColDoc.h"

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CElevColorDlg 

class CElevColorDoc;
class CElevColorDlg : public CDlgTool
{
	#define COLTABLE_CNT 8
	#define INDEX_LEN 4

private:

	CElevColorDoc* m_ptDoc;			// CColorTableDoc with elevation dimension

	COLORREF m_Color00;
	COLORREF m_Color01;
	COLORREF m_Color02;
	COLORREF m_Color03;
	COLORREF m_Color04;
	COLORREF m_Color05;
	COLORREF m_Color06;
	COLORREF m_Color07;


// Konstruktion
public:
	CElevColorDlg(CWnd* pParent = NULL, CElevColorDoc* ptDoc=NULL, int mode=0);   // Standardkonstruktor

// Dialogfelddaten
	//{{AFX_DATA(CElevColorDlg)
	enum { IDD = IDD_COLTABLEDLG };
	int		m_nElevDimIndex;
	int		m_nFinalCnt;
	int		m_nIndex00;
	int		m_nIndex01;
	int		m_nIndex02;
	int		m_nIndex03;
	int		m_nIndex04;
	int		m_nIndex05;
	int		m_nIndex06;
	int		m_nIndex07;
	CString	m_szElev00;
	CString	m_szElev01;
	CString	m_szElev02;
	CString	m_szElev03;
	CString	m_szElev04;
	CString	m_szElev05;
	CString	m_szElev06;
	CString	m_szElev07;
	CString	m_szTitle;
	//}}AFX_DATA


// berschreibungen
	// Vom Klassen-Assistenten generierte virtuelle Funktionsberschreibungen
	//{{AFX_VIRTUAL(CElevColorDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV-Untersttzung
	//}}AFX_VIRTUAL

// Implementierung
	private:
		CElevColorDoc::Mode m_Mode;
	private:
		void SetIndex (int i, int nIndex);
		int GetIndex (int i);
		void SetColor (int i, COLORREF Color);
		COLORREF GetColor (int i);
		void SetElevText (int i, CString szElev);

		void InitTable(int nCnt);
		void SetData();
		void DrawRect (UINT uID, COLORREF Col);
		CString IndexToElevText (int nIndex);
		void OnChangeIndex (UINT uIndexID, UINT uElevID);
		void ChangeColorDlg (UINT uFrameID, COLORREF* ptCol);

protected:

	// Generierte Nachrichtenzuordnungsfunktionen
	//{{AFX_MSG(CElevColorDlg)
	afx_msg void OnChangeColor00();
	afx_msg void OnChangeColor01();
	afx_msg void OnChangeColor02();
	afx_msg void OnChangeColor03();
	afx_msg void OnChangeColor04();
	afx_msg void OnChangeColor05();
	afx_msg void OnChangeColor06();
	afx_msg void OnChangeColor07();
	afx_msg void OnPaint();
	afx_msg void OnColorsReset();
	virtual void OnOK();
	virtual BOOL OnInitDialog();
	afx_msg void OnChangeInd00();
	afx_msg void OnChangeInd01();
	afx_msg void OnChangeInd02();
	afx_msg void OnChangeInd03();
	afx_msg void OnChangeInd04();
	afx_msg void OnChangeInd05();
	afx_msg void OnChangeInd06();
	afx_msg void OnChangeInd07();
	afx_msg void OnSelchangeElevDim();
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // AFX_COLTBDLG_H__4B2A9510_DDAF_4F58_989F_02B0E5582667__INCLUDED_
